/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.conndata;

import com.ibm.hwmca.base.rsf.conndata.DunAccountInfo;
import com.ibm.hwmca.base.rsf.conndata.RetainConnectionDataManager;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.util.Trace;

public class RetainIspAccountInfo {
    private static final String TRACE_MASKT = "XCDIRAIT";
    private static final String TRACE_MASKF = "XCDIRAIF";
    private static final String TRACE_MASKD = "XCDIRAID";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(-89, "RetIspAccInf");
    static final int ISO_COUNTRY_START = 0;
    static final int ISO_COUNTRY_END = 2;
    static final int ACCOUNT_START = 3;
    static final int ACCOUNT_END = 11;
    static final int USERID_START = 12;
    static final int USERID_END = 20;
    static final int PASSWORD_START = 21;
    static final int PASSWORD_END = 29;
    private static String cacheLocale = "";
    private static DunAccountInfo cacheValue = null;

    private RetainIspAccountInfo() {
        Trace.trace(TRACE_MASKT, "<> RetainIspAccountInfo()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DunAccountInfo getAccountInfo(String countryAbbreviation) throws IllegalArgumentException, HException {
        Trace.trace(TRACE_MASKT, "-> RetainIspAccountInfo.getAccountInfo() - " + countryAbbreviation);
        if (countryAbbreviation == null) {
            String msg = "Country parameter can not be null";
            IllegalArgumentException e = new IllegalArgumentException(msg);
            throw e;
        }
        String cCodeIn = countryAbbreviation.trim().toUpperCase();
        if (cCodeIn.length() != 2) {
            String msg = "Parameter >" + countryAbbreviation + "< is not a valid country abbreviation";
            IllegalArgumentException e = new IllegalArgumentException(msg);
            throw e;
        }
        String localeIn = cCodeIn;
        String string = cacheLocale;
        synchronized (string) {
            if (cacheLocale.equals(localeIn)) {
                DunAccountInfo newInfo = (DunAccountInfo)cacheValue.clone();
                Trace.trace(TRACE_MASKT, "<- RetainIspAccountInfo.getAccountInfo() - used cached value - " + newInfo);
                return newInfo;
            }
        }
        String[] lines = RetainConnectionDataManager.getAccountData();
        boolean found = false;
        DunAccountInfo newInfo = null;
        int i = 0;
        while (i < lines.length) {
            String cCode = lines[i].substring(0, 2);
            if (localeIn.equals(cCode)) {
                String account = lines[i].substring(3, 11).trim();
                String userid = lines[i].substring(12, 20).trim();
                String password = lines[i].substring(21, 29).trim();
                newInfo = new DunAccountInfo(account, userid, password);
                found = true;
            }
            ++i;
        }
        if (!found) {
            String msg = "Country >" + localeIn + "< not found in database";
            IllegalArgumentException e = new IllegalArgumentException(msg);
            throw e;
        }
        String string2 = cacheLocale;
        synchronized (string2) {
            cacheLocale = localeIn;
            cacheValue = (DunAccountInfo)newInfo.clone();
        }
        Trace.trace(TRACE_MASKT, "<- RetainIspAccountInfo.getAccountInfo() - " + newInfo);
        return newInfo;
    }

    static void dumpCache() {
        Trace.trace(TRACE_MASKT, "-> RetainIspAccountInfo.dumpCache()");
        cacheLocale = "";
        cacheValue = null;
        Trace.trace(TRACE_MASKT, "<- RetainIspAccountInfo.dumpCache()");
    }
}

